//
//  SPBoxView-IBIntegration.m
//  SamplePlugIn
//
//  Created by Kai on 12.1.08.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

//#import <InterfaceBuilderKit/InterfaceBuilderKit.h>
#import <InterfaceBuilderKit/IBObjectIntegration.h>
#import <InterfaceBuilderKit/IBViewIntegration.h>

#import "IBDocument+Private.h"
#import "IBConnection-Private.h"

#import "SPBoxView.h"
#import "SPBoxView-IBIntegration.h"
#import "SPLinearGradient.h"
#import "SamplePlugIn.h"


//-------------------------------------------------------------------------------------------
@implementation SPBoxView (IBIntegration)
//-------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------
- (BOOL) isInternalShadow {
	return _boxShadow != nil;
}

//-------------------------------------------------------------------------------------------
- (void) setInternalShadow:(BOOL)value {
	if (value) {
		if (_boxShadow == nil) {
			NSShadow* oldShadow = [self boxShadow];
			if (oldShadow) {
				_boxShadow = [oldShadow copy];
			} else {
				_boxShadow = [[NSShadow alloc] init];
				[_boxShadow setShadowOffset:NSMakeSize(3.0, -3.0)];
				[_boxShadow setShadowBlurRadius:3.0];
				[_boxShadow setShadowColor:[NSColor blackColor]];
			}
			[[IBDocument documentForObject:self] addObject:_boxShadow toParent:self];
		}
	} else {
		if (_boxShadow) {
			[[IBDocument documentForObject:self] removeObject:_boxShadow];
			[_boxShadow release], _boxShadow = nil;
		}
	}
	[self setNeedsDisplay:YES];
}

//-------------------------------------------------------------------------------------------
- (BOOL) isInternalGradient {
	return _gradient != nil;
}

//-------------------------------------------------------------------------------------------
- (void) setInternalGradient:(BOOL)value {
	if (value) {
		if (_gradient == nil) {
			SPLinearGradient* oldGradient = [self gradient];
			if (oldGradient) {
				_gradient = [oldGradient copy];
			} else {
				_gradient = [[SPLinearGradient alloc] init];
				[_gradient setStartingColor:[NSColor whiteColor]];
				[_gradient setEndingColor:[NSColor blackColor]];
			}
			[[IBDocument documentForObject:self] addObject:_gradient toParent:self];
		}
	} else {
		if (_gradient) {
			[[IBDocument documentForObject:self] removeObject:_gradient];
			[_gradient release], _gradient = nil;
		}
	}
	[self setNeedsDisplay:YES];
}

#pragma mark IBObjectIntegration ------------------------------------------------------------
//-------------------------------------------------------------------------------------------
- (void) ibPopulateKeyPaths:(NSMutableDictionary*)keyPaths {
	[super ibPopulateKeyPaths:keyPaths];
	
	// Remove the comments and replace "MyFirstProperty" and "MySecondProperty" 
	// in the following line with a list of your view's KVC-compliant properties.
	[[keyPaths objectForKey:IBAttributeKeyPaths] addObjectsFromArray:
					[NSArray arrayWithObjects:@"cornerRadius",
													  @"fillColor",
													  @"borderColor",
													  @"borderWidth",
													  nil]];
}

//-------------------------------------------------------------------------------------------
- (void) ibPopulateAttributeInspectorClasses:(NSMutableArray*)classes {
	[super ibPopulateAttributeInspectorClasses:classes];
	[classes addObject:[SPBoxView_IBInspector class]];
}

//-------------------------------------------------------------------------------------------
- (void) ibAwakeInDesignableDocument:(IBDocument*)document {
//	NSLog (@"ibAwakeInDesignableDocument for %@ in %@\n", self, document);
}

- (void) ibDidAddToDesignableDocument:(IBDocument*)document {
//	NSLog (@"ibDidAddToDesignableDocument for %@ in %@\n", self, document);
//	[[SamplePlugIn sharedInstance] addOutletObserver:self label:@"_boxShadow" inDocument:document];
}

- (void) ibDidRemoveFromDesignableDocument:(IBDocument*)document {
//	NSLog (@"ibDidRemoveFromDesignableDocument for %@ in %@\n", self, document);
	[[SamplePlugIn sharedInstance] removeOutletFor:self
													  label:@"_gradient"
												 toObserve:[NSArray arrayWithObject:@"appearance"]];
	[[SamplePlugIn sharedInstance] removeOutletFor:self
													  label:@"_boxShadow"
												 toObserve:[NSArray arrayWithObject:@"appearance"]];
}



#pragma mark IBViewIntegration --------------------------------------------------------------
//-------------------------------------------------------------------------------------------
- (NSView*) ibDesignableContentView {
	// Allow embedding childs at design time: this is a container view.
	return self;
}

//-------------------------------------------------------------------------------------------
- (IBInset) ibLayoutInset {
	// Make sure insets are valid.
	[self calculateInsets];

	IBInset insets;
	insets.left   = _leftInset;
	insets.top    = _topInset;
	insets.right  = _rightInset;
	insets.bottom = _bottomInset;
	return insets;
}

//-------------------------------------------------------------------------------------------
// test test:
- (IBDocument*) ibDocument {
	return [IBDocument documentForObject:self];
}


#pragma mark SPBoxView Overrides ------------------------------------------------------------
//-------------------------------------------------------------------------------------------
- (SPLinearGradient*) gradient {
	// Here’s the trick: while in design mode, this overwrite looks for a gradient object
	// which is connected to this box via an outlet.
	// Note: this method depends on the fact, that -[SPBoxView gradient] isn’t called for
	// conflicting uses by IB. This seems to be true to my knowledge so far, but if it proves
	// wrong eventually, another method might need to be added for this purpose.
	SPLinearGradient* gradientToUse = _gradient;
	
	if (gradientToUse == nil)
		gradientToUse = [[SamplePlugIn sharedInstance]
							  checkOutletFor:self label:@"_gradient"
							  toObserve:[NSArray arrayWithObject:@"appearance"]];
	
	return [[gradientToUse retain] autorelease];
}

//-------------------------------------------------------------------------------------------
- (NSShadow*) boxShadow {
	// Here’s the trick: while in design mode, this overwrite looks for a shadow object which
	// is connected to this box via an outlet.
	// Note: this method depends on the fact, that -[SPBoxView boxShadow] isn’t called for
	// conflicting uses by IB. This seems to be true to my knowledge so far, but if it proves
	// wrong eventually, another method might need to be added for this purpose.
	NSShadow* shadowToUse = _boxShadow;
	
	if (shadowToUse == nil)
		shadowToUse = [[SamplePlugIn sharedInstance]
							checkOutletFor:self label:@"_boxShadow"
							toObserve:[NSArray arrayWithObject:@"appearance"]];

	// Simply recalculate the insets each time the view is drawn in design mode.
	_insetsAreValid = NO;

	return [[shadowToUse retain] autorelease];
}

//-------------------------------------------------------------------------------------------
- (void) observeValueForKeyPath:(NSString*)keyPath
							  ofObject:(id)object
								 change:(NSDictionary*)change
								context:(void*)context {
	if ([keyPath isEqualToString:@"appearance"]) {
		[self setNeedsDisplay:YES];
	} else {
		[super observeValueForKeyPath:keyPath ofObject:object change:change context:context];
	}
}


//-------------------------------------------------------------------------------------------
@end


//-------------------------------------------------------------------------------------------
@implementation SPBoxView_IBInspector
//-------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------
- (NSString*) viewNibName {
	return @"SPBoxViewIBInspector";
}

//-------------------------------------------------------------------------------------------
- (NSString*) label {
	return @"Box View";
}

//-------------------------------------------------------------------------------------------
/*- (void) refresh {
	// Synchronize your inspector's content view with the currently selected objects.
	[super refresh];
}*/

@end
